/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.okhttp;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import okhttp3.Response;
import org.dmfs.httpessentials.headers.FilteredHeaders;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.headers.UpdatedHeaders;

final class OkHttpResponseHeaders
implements Headers {
    private final Response mResponse;

    public OkHttpResponseHeaders(Response response) {
        this.mResponse = response;
    }

    public boolean contains(HeaderType<?> headerType) {
        return this.mResponse.header(headerType.name()) != null;
    }

    public <T> Header<T> header(SingletonHeaderType<T> headerType) {
        return headerType.entityFromString(this.mResponse.header(headerType.name()));
    }

    public <T> Header<List<T>> header(ListHeaderType<T> headerType) {
        List headers = this.mResponse.headers(headerType.name());
        if (headers.isEmpty()) {
            return headerType.entity(Collections.emptyList());
        }
        Iterator iterator = headers.iterator();
        Header result = headerType.entityFromString((String)iterator.next());
        while (iterator.hasNext()) {
            headerType.merged(result, headerType.entityFromString((String)iterator.next()));
        }
        return result;
    }

    public <T> Headers withHeader(Header<T> header) {
        return new UpdatedHeaders((Headers)this, header);
    }

    public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
        return new FilteredHeaders((Headers)this, new HeaderType[]{headerType});
    }

    public Iterator<Header<?>> iterator() {
        throw new UnsupportedOperationException("These headers don't support iterating");
    }
}

