/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.okhttp;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.decorators.Mapped;
import org.dmfs.jems.single.combined.Backed;

final class OkHttpRequestBody
extends RequestBody {
    private final HttpRequestEntity mRequestEntity;

    public OkHttpRequestBody(HttpRequestEntity requestEntity) {
        this.mRequestEntity = requestEntity;
    }

    public long contentLength() {
        return (Long)new Backed(this.mRequestEntity.contentLength(), (Object)-1L).value();
    }

    public MediaType contentType() {
        return (MediaType)new Backed((Optional)new Mapped(mediaType -> MediaType.parse((String)mediaType.toString()), this.mRequestEntity.contentType()), () -> null).value();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.mRequestEntity.writeContent(sink.outputStream());
    }
}

