/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.scope;

import org.dmfs.iterables.Split;
import org.dmfs.iterators.UnquotedSplit;
import org.dmfs.oauth2.client.OAuth2Scope;

public final class StringScope
implements OAuth2Scope {
    private final String mScope;

    public StringScope(String scope) {
        this.mScope = scope;
    }

    @Override
    public boolean hasToken(String token) {
        UnquotedSplit tokenIterator = new UnquotedSplit((CharSequence)this.mScope, ' ');
        while (tokenIterator.hasNext()) {
            if (!((CharSequence)tokenIterator.next()).toString().equals(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int tokenCount() {
        if (this.mScope.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (CharSequence token : new Split((CharSequence)this.mScope, ' ')) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.mScope.isEmpty();
    }

    @Override
    public String toString() {
        return this.mScope;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OAuth2Scope)) {
            return false;
        }
        OAuth2Scope other = (OAuth2Scope)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.tokenCount() != other.tokenCount()) {
            return false;
        }
        UnquotedSplit tokens = new UnquotedSplit((CharSequence)this.mScope, ' ');
        while (tokens.hasNext()) {
            if (other.hasToken(((CharSequence)tokens.next()).toString())) continue;
            return false;
        }
        return true;
    }
}

