/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.http.requests;

import org.dmfs.httpessentials.HttpMethod;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.entities.XWwwFormUrlEncodedEntity;
import org.dmfs.httpessentials.headers.EmptyHeaders;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.responsehandlers.FailResponseHandler;
import org.dmfs.jems.pair.Pair;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.responsehandlers.TokenErrorResponseHandler;
import org.dmfs.oauth2.client.http.responsehandlers.TokenResponseHandler;

public abstract class AbstractAccessTokenRequest
implements HttpRequest<OAuth2AccessToken> {
    private final OAuth2Scope mScope;
    private final HttpRequestEntity mEntity;

    public AbstractAccessTokenRequest(OAuth2Scope scope, Iterable<Pair<CharSequence, CharSequence>> parameters) {
        this(scope, (HttpRequestEntity)new XWwwFormUrlEncodedEntity(parameters, "UTF-8"));
    }

    public AbstractAccessTokenRequest(OAuth2Scope scope, HttpRequestEntity entityGenerator) {
        this.mScope = scope;
        this.mEntity = entityGenerator;
    }

    public final HttpMethod method() {
        return HttpMethod.POST;
    }

    public final Headers headers() {
        return EmptyHeaders.INSTANCE;
    }

    public final HttpRequestEntity requestEntity() {
        return this.mEntity;
    }

    public final HttpResponseHandler<OAuth2AccessToken> responseHandler(HttpResponse response) {
        if (!HttpStatus.OK.equals((Object)response.status())) {
            if (!HttpStatus.BAD_REQUEST.equals((Object)response.status())) {
                return FailResponseHandler.getInstance();
            }
            return new TokenErrorResponseHandler();
        }
        return new TokenResponseHandler(this.mScope);
    }
}

