/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.decoration.Decoration;
import org.dmfs.httpessentials.decoration.HeaderDecorated;
import org.dmfs.oauth2.client.OAuth2ClientCredentials;
import org.dmfs.oauth2.client.http.decorators.BasicAuthHeaderDecoration;

public final class BasicOAuth2ClientCredentials
implements OAuth2ClientCredentials {
    private final String mClientId;
    private final String mClientSecret;

    public BasicOAuth2ClientCredentials(String clientId, String clientSecret) {
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
    }

    @Override
    public <T> HttpRequest<T> authenticatedRequest(HttpRequest<T> request) {
        return new HeaderDecorated(request, (Decoration)new BasicAuthHeaderDecoration(this.mClientId, this.mClientSecret));
    }

    @Override
    public String clientId() {
        return this.mClientId;
    }
}

