/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.NoSuchElementException;
import org.dmfs.rfc5545.recur.RecurrenceRuleIterator;
import org.dmfs.rfc5545.recurrenceset.AbstractRecurrenceAdapter;

public final class CountLimitedRecurrenceRuleIterator
implements AbstractRecurrenceAdapter.InstanceIterator {
    private final RecurrenceRuleIterator mDelegate;
    private int mRemaining;

    public CountLimitedRecurrenceRuleIterator(RecurrenceRuleIterator delegate, int remaining) {
        this.mDelegate = delegate;
        this.mRemaining = remaining;
    }

    @Override
    public boolean hasNext() {
        return this.mRemaining > 0 && this.mDelegate.hasNext();
    }

    @Override
    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No further elements to iterate");
        }
        --this.mRemaining;
        return this.mDelegate.nextMillis();
    }

    @Override
    public void fastForward(long until) {
        while (this.hasNext() && this.mDelegate.peekMillis() < until) {
            this.next();
        }
    }
}

