/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByYearDayYearlyExpander
extends ByExpander {
    private final int[] mYearDays;

    public ByYearDayYearlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start) {
        super(previous, calendarMetrics, start);
        this.mYearDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYYEARDAY));
    }

    @Override
    void expand(long instance, long start) {
        int year = Instance.year((long)instance);
        int yearDays = this.mCalendarMetrics.getDaysPerYear(year);
        int startDayOfYear = this.mCalendarMetrics.getDayOfYear(Instance.year((long)start), Instance.month((long)start), Instance.dayOfMonth((long)start));
        int[] nArray = this.mYearDays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int monthAndDay;
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + yearDays + 1;
            }
            if (0 < actualDay && actualDay <= yearDays && (actualDay >= startDayOfYear || year != Instance.year((long)start))) {
                monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay);
                this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
                continue;
            }
            if (actualDay <= 0) {
                this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)0, (int)0));
                continue;
            }
            if (actualDay <= yearDays) continue;
            monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDays);
            this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)(CalendarMetrics.dayOfMonth((int)monthAndDay) + 1)));
        }
    }
}

