/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByYearDayMonthlyExpander
extends ByExpander {
    private final int[] mYearDays;

    public ByYearDayMonthlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics, long start) {
        super(previous, calendarMetrics, start);
        this.mYearDays = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYYEARDAY));
    }

    @Override
    void expand(long instance, long start) {
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int yearDays = this.mCalendarMetrics.getDaysPerYear(year);
        int startDayOfYear = this.mCalendarMetrics.getDayOfYear(Instance.year((long)start), Instance.month((long)start), Instance.dayOfMonth((long)start));
        int[] nArray = this.mYearDays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int monthAndDay;
            int newMonth;
            int day;
            int actualDay = day = nArray[i];
            if (day < 0) {
                actualDay = day + yearDays + 1;
            }
            if (0 >= actualDay || actualDay > yearDays || actualDay < startDayOfYear && year == Instance.year((long)start) || (newMonth = CalendarMetrics.packedMonth((int)(monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, actualDay)))) != month) continue;
            this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)newMonth, (int)CalendarMetrics.dayOfMonth((int)monthAndDay)));
        }
    }
}

