/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByYearDayFilter
implements ByFilter {
    private final int[] mYearDays;
    private final CalendarMetrics mCalendarMetrics;

    public ByYearDayFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) {
        this.mCalendarMetrics = calendarMetrics;
        this.mYearDays = StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYYEARDAY));
    }

    @Override
    public boolean filter(long instance) {
        int year = Instance.year((long)instance);
        int yearDays = this.mCalendarMetrics.getDaysPerYear(year);
        int dayOfYear = this.mCalendarMetrics.getDayOfYear(year, Instance.month((long)instance), Instance.dayOfMonth((long)instance));
        return StaticUtils.linearSearch(this.mYearDays, dayOfYear) < 0 && StaticUtils.linearSearch(this.mYearDays, dayOfYear - yearDays) < 0 || dayOfYear > yearDays;
    }
}

