/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByWeekNoYearlyExpander
extends ByExpander {
    private final int[] mByWeekNo;
    private final int mOriginalWeekDay;

    public ByWeekNoYearlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mByWeekNo = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYWEEKNO));
        this.mOriginalWeekDay = calendarTools.getDayOfWeek(Instance.year((long)start), Instance.month((long)start), Instance.dayOfMonth((long)start));
    }

    @Override
    void expand(long instance, long notBefore) {
        int year = Instance.year((long)instance);
        int yearWeeks = this.mCalendarMetrics.getWeeksPerYear(year);
        int[] nArray = this.mByWeekNo;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int weekOfYear;
            int actualWeek = weekOfYear = nArray[i];
            if (weekOfYear < 0) {
                actualWeek = yearWeeks + weekOfYear + 1;
            }
            if (actualWeek <= 0 || actualWeek > yearWeeks) {
                if (actualWeek <= 0) {
                    this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)0, (int)0));
                    continue;
                }
                int monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, this.mCalendarMetrics.getDaysPerYear(year));
                this.addInstance(Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)(CalendarMetrics.dayOfMonth((int)monthAndDay) + 1)));
                continue;
            }
            int yearDay = this.mCalendarMetrics.getYearDayOfIsoYear(year, actualWeek, this.mOriginalWeekDay);
            int yearOffset = 0;
            if (yearDay < 1) {
                yearOffset = -1;
                yearDay += this.mCalendarMetrics.getDaysPerYear(year);
            } else if (yearDay > this.mCalendarMetrics.getDaysPerYear(year)) {
                yearDay -= this.mCalendarMetrics.getDaysPerYear(year);
                yearOffset = 1;
            }
            int monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(year, yearDay);
            this.addInstance(Instance.setYear((long)Instance.setMonthAndDayOfMonth((long)instance, (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay)), (int)(year + yearOffset)));
        }
    }
}

