/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByMonthExpander
extends ByExpander {
    private final int[] mMonths;

    public ByMonthExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        this.mMonths = StaticUtils.ListToSortedArray(rule.getByPart(RecurrenceRule.Part.BYMONTH));
    }

    @Override
    void expand(long instance, long start) {
        for (int month : this.mMonths) {
            long newInstance = Instance.setMonth((long)instance, (int)month);
            if (newInstance < start) continue;
            this.addInstance(newInstance);
        }
    }
}

