/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.function;

import org.dmfs.jems2.Function;
import org.dmfs.jems2.ThrowingFunction;

public final class Unchecked<Argument, Result, E extends Throwable>
implements Function<Argument, Result> {
    private final Function<? super E, ? extends RuntimeException> mExceptionFunction;
    private final ThrowingFunction<Argument, Result> mDelegate;

    public Unchecked(ThrowingFunction<Argument, Result> delegate) {
        this("Function call failed", delegate);
    }

    public Unchecked(String message, ThrowingFunction<Argument, Result> delegate) {
        this((? super E exception) -> new RuntimeException(message, (Throwable)exception), delegate);
    }

    public Unchecked(Function<? super E, ? extends RuntimeException> exceptionFunction, ThrowingFunction<Argument, Result> delegate) {
        this.mExceptionFunction = exceptionFunction;
        this.mDelegate = delegate;
    }

    @Override
    public Result value(Argument argument) {
        try {
            return this.mDelegate.value(argument);
        }
        catch (Throwable e) {
            throw this.mExceptionFunction.value(e);
        }
    }
}

