/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.charsequence;

import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class CharSequenceCharAtMatcher
extends TypeSafeDiagnosingMatcher<CharSequence> {
    private final CharSequence mExpectedValue;

    public static CharSequenceCharAtMatcher hasChars(CharSequence expectedValues) {
        return new CharSequenceCharAtMatcher(expectedValues);
    }

    public CharSequenceCharAtMatcher(CharSequence expectedValue) {
        this.mExpectedValue = expectedValue;
    }

    protected boolean matchesSafely(CharSequence item, Description mismatchDescription) {
        for (int i = -this.mExpectedValue.length() - 1; i < this.mExpectedValue.length() * 2 + 1; ++i) {
            if (i < 0 || i >= this.mExpectedValue.length()) {
                try {
                    item.charAt(i);
                    mismatchDescription.appendText(String.format(Locale.ENGLISH, "Did not throw when accessing index %d", i));
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
            }
            if (item.charAt(i) == this.mExpectedValue.charAt(i)) continue;
            mismatchDescription.appendText(String.format(Locale.ENGLISH, "char at %d was '%c'", i, Character.valueOf(item.charAt(i))));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("chars match \"").appendText(this.mExpectedValue.toString()).appendText("\"");
    }
}

