/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.procedure;

import org.dmfs.jems2.Generator;
import org.dmfs.jems2.Procedure;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ProcedureMatcher<Argument>
extends TypeSafeDiagnosingMatcher<Procedure<? super Argument>> {
    private final Generator<? extends Argument> mArgumentGenerator;
    private final Matcher<? super Argument> mDelegate;

    public static <Argument> Matcher<Procedure<? super Argument>> processes(Generator<? extends Argument> argumentGenerator, Matcher<? super Argument> delegate) {
        return new ProcedureMatcher<Argument>(argumentGenerator, delegate);
    }

    public ProcedureMatcher(Generator<? extends Argument> argumentGenerator, Matcher<? super Argument> delegate) {
        this.mArgumentGenerator = argumentGenerator;
        this.mDelegate = delegate;
    }

    protected boolean matchesSafely(Procedure<? super Argument> item, Description mismatchDescription) {
        Object argument = this.mArgumentGenerator.next();
        item.process(argument);
        if (!this.mDelegate.matches(argument)) {
            mismatchDescription.appendText("processed argument ");
            this.mDelegate.describeMismatch(argument, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("processes ").appendValue(this.mArgumentGenerator.next()).appendText(" to ").appendDescriptionOf(this.mDelegate);
    }
}

