/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.fragile;

import org.dmfs.jems2.Fragile;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class FragileMatcher<T>
extends TypeSafeDiagnosingMatcher<Fragile<T, ?>> {
    private final Matcher<? super T> mDelegate;

    public static <T> Matcher<Fragile<T, ?>> hasValue(Matcher<T> valueMatcher) {
        return new FragileMatcher<T>(valueMatcher);
    }

    public static <T> Matcher<Fragile<T, ?>> hasValue(T expectedValue) {
        return new FragileMatcher<T>(CoreMatchers.equalTo(expectedValue));
    }

    public FragileMatcher(Matcher<? super T> valueMatcher) {
        this.mDelegate = valueMatcher;
    }

    protected boolean matchesSafely(Fragile<T, ?> item, Description mismatchDescription) {
        try {
            boolean result = this.mDelegate.matches(item.value());
            if (!result) {
                mismatchDescription.appendText("intact Fragile ");
                this.mDelegate.describeMismatch(item.value(), mismatchDescription);
            }
            return result;
        }
        catch (Throwable throwable) {
            mismatchDescription.appendText(String.format("broken throwing %s", throwable.getClass().getName()));
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("intact Fragile ");
        this.mDelegate.describeTo(description);
    }
}

