/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.fragile;

import org.dmfs.jems2.Fragile;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class BrokenFragileMatcher
extends TypeSafeDiagnosingMatcher<Fragile<?, ?>> {
    private final Matcher<? super Throwable> mExceptionMatcher;

    public static Matcher<Fragile<?, ?>> throwing(Matcher<? super Throwable> exceptionMatcher) {
        return new BrokenFragileMatcher(exceptionMatcher);
    }

    public static Matcher<Fragile<?, ?>> throwing(Class<? extends Throwable> exceptionClass) {
        return new BrokenFragileMatcher((Matcher<? super Throwable>)CoreMatchers.instanceOf(exceptionClass));
    }

    public BrokenFragileMatcher(Matcher<? super Throwable> exceptionMatcher) {
        this.mExceptionMatcher = exceptionMatcher;
    }

    protected boolean matchesSafely(Fragile<?, ?> item, Description mismatchDescription) {
        try {
            item.value();
            mismatchDescription.appendText("Fragile was not broken");
            return false;
        }
        catch (Throwable throwable) {
            if (!this.mExceptionMatcher.matches((Object)throwable)) {
                mismatchDescription.appendText("broken Fragile threw ");
                this.mExceptionMatcher.describeMismatch((Object)throwable, mismatchDescription);
                return false;
            }
            return true;
        }
    }

    public void describeTo(Description description) {
        description.appendText("broken Fragile throwing ");
        description.appendDescriptionOf(this.mExceptionMatcher);
    }
}

