/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.comparable;

import java.util.Comparator;
import org.dmfs.jems2.iterable.Seq;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ComparableEqualsMatcher<T>
extends TypeSafeDiagnosingMatcher<Comparator<T>> {
    private final Iterable<? extends T> mEqualValues;

    @SafeVarargs
    public static <T> Matcher<Comparator<T>> considersEqual(T ... equalValues) {
        return new ComparableEqualsMatcher<T>(new Seq((Object[])equalValues));
    }

    public ComparableEqualsMatcher(Iterable<? extends T> equalValues) {
        this.mEqualValues = equalValues;
    }

    protected boolean matchesSafely(Comparator<T> item, Description mismatchDescription) {
        for (T left : this.mEqualValues) {
            for (T right : this.mEqualValues) {
                if (item.compare(left, right) == 0) continue;
                mismatchDescription.appendValue(left).appendText(" and ").appendValue(right).appendText(" compared non-equal but to ").appendValue((Object)item.compare(left, right));
                return false;
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValueList("considers the following elements equal: ", ",", "", this.mEqualValues);
    }
}

