/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.hamcrest.matchers.pair;

import org.dmfs.jems2.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class PairMatcher<L, R>
extends TypeSafeDiagnosingMatcher<Pair<? extends L, ? extends R>> {
    private final Matcher<? super L> mLeftValueMatcher;
    private final Matcher<? super R> mRightValueMatcher;

    public PairMatcher(Matcher<? super L> leftValueMatcher, Matcher<? super R> rightValueMatcher) {
        this.mLeftValueMatcher = leftValueMatcher;
        this.mRightValueMatcher = rightValueMatcher;
    }

    protected boolean matchesSafely(Pair<? extends L, ? extends R> actualPair, Description mismatchDescription) {
        if (!this.mLeftValueMatcher.matches(actualPair.left())) {
            mismatchDescription.appendText("Left value doesn't match: ");
            this.mLeftValueMatcher.describeMismatch(actualPair.left(), mismatchDescription);
            return false;
        }
        if (!this.mRightValueMatcher.matches(actualPair.right())) {
            mismatchDescription.appendText("Right value doesn't match: ");
            this.mRightValueMatcher.describeMismatch(actualPair.right(), mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("is Pair with left value: ");
        this.mLeftValueMatcher.describeTo(description);
        description.appendText(" , and right value: ");
        this.mRightValueMatcher.describeTo(description);
    }

    public static <L, R> Matcher<Pair<? extends L, ? extends R>> pair(L leftValue, R rightValue) {
        return new PairMatcher<L, R>(CoreMatchers.equalTo(leftValue), CoreMatchers.equalTo(rightValue));
    }

    public static <L, R> Matcher<Pair<? extends L, ? extends R>> pair(Matcher<? super L> leftValueMatcher, Matcher<? super R> rightValueMatcher) {
        return new PairMatcher<L, R>(leftValueMatcher, rightValueMatcher);
    }
}

