/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.messagedigest.elementary;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.dmfs.jems.messagedigest.MessageDigestFactory;

public final class DigestFactory
implements MessageDigestFactory {
    private final String mAlgorithm;

    public DigestFactory(String algorithm) {
        this.mAlgorithm = algorithm;
    }

    @Override
    public MessageDigest newInstance() throws RuntimeException {
        try {
            return MessageDigest.getInstance(this.mAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Algorithm %s not supported by runtime.", this.mAlgorithm), e);
        }
    }
}

