/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.httpurlconnection.factories.decorators;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import org.dmfs.httpessentials.httpurlconnection.HttpUrlConnectionFactory;

public final class Finite
implements HttpUrlConnectionFactory {
    public static final int DEFAULT_SOCKET_TIMEOUT = 120000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private final HttpUrlConnectionFactory mDecorated;
    private final int mConnectionTimeout;
    private final int mSocketTimeout;

    public Finite(HttpUrlConnectionFactory decorated) {
        this(decorated, 10000, 120000);
    }

    public Finite(HttpUrlConnectionFactory decorated, int connectionTimeout, int socketTimeout) {
        this.mDecorated = decorated;
        this.mConnectionTimeout = connectionTimeout;
        this.mSocketTimeout = socketTimeout;
    }

    @Override
    public HttpURLConnection httpUrlConnection(URI uri) throws IllegalArgumentException, IOException {
        HttpURLConnection connection = this.mDecorated.httpUrlConnection(uri);
        if (this.mConnectionTimeout >= 0) {
            connection.setConnectTimeout(this.mConnectionTimeout);
        }
        if (this.mSocketTimeout >= 0) {
            connection.setReadTimeout(this.mSocketTimeout);
        }
        return connection;
    }
}

