/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials;

import org.dmfs.httpessentials.methods.IdempotentMethod;
import org.dmfs.httpessentials.methods.Method;
import org.dmfs.httpessentials.methods.SafeMethod;

public interface HttpMethod {
    public static final HttpMethod GET = new SafeMethod("GET", false);
    public static final HttpMethod HEAD = new SafeMethod("HEAD", false);
    public static final HttpMethod POST = new Method("POST", true);
    public static final HttpMethod PUT = new IdempotentMethod("PUT", true);
    public static final HttpMethod DELETE = new IdempotentMethod("DELETE", false);
    public static final HttpMethod CONNECT = new Method("CONNECT", false);
    public static final HttpMethod OPTIONS = new SafeMethod("OPTIONS", true);
    public static final HttpMethod TRACE = new SafeMethod("TRACE", false);
    public static final HttpMethod PATCH = new Method("PATCH", true);

    public String verb();

    public boolean isSafe();

    public boolean isIdempotent();

    public boolean supportsRequestPayload();
}

