/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.express.json.elementary;

import java.io.IOException;
import org.dmfs.express.json.JsonSink;
import org.dmfs.express.json.JsonValue;
import org.dmfs.jems2.charsequence.Hex;

public final class String
implements JsonValue {
    private final CharSequence mString;

    public String(CharSequence string) {
        this.mString = string;
    }

    @Override
    public void serialize(JsonSink jsonSink) throws IOException {
        int end;
        jsonSink.writeJson("\"");
        int start = 0;
        int length = this.mString.length();
        for (end = 0; end < length; ++end) {
            char c = this.mString.charAt(end);
            if (c >= ' ' && c != '\"' && c != '\\') continue;
            if (start != end) {
                jsonSink.writeJson(this.mString.subSequence(start, end));
            }
            if (c >= ' ') {
                jsonSink.writeJson("\\");
                jsonSink.writeJson(new java.lang.String(new char[]{c}));
            } else if (c == '\n') {
                jsonSink.writeJson("\\n");
            } else if (c == '\r') {
                jsonSink.writeJson("\\r");
            } else if (c == '\t') {
                jsonSink.writeJson("\\t");
            } else {
                jsonSink.writeJson("\\u00");
                jsonSink.writeJson((CharSequence)new Hex(new byte[]{(byte)c}));
            }
            start = end + 1;
        }
        if (start != end) {
            jsonSink.writeJson(this.mString.subSequence(start, end));
        }
        jsonSink.writeJson("\"");
    }
}

