/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.rmi;

import java.net.InetAddress;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.djutils.exceptions.Throw;
import org.djutils.logger.CategoryLogger;

public final class RmiRegistry {
    private RmiRegistry() {
    }

    public static Registry getRegistry(String host, int port) throws RemoteException {
        Throw.whenNull(host, "host cannot be null");
        Throw.when(port <= 0 || port > 65535, IllegalArgumentException.class, "port <= 0 or port > 65535");
        try {
            boolean validRegistry;
            Registry registry = LocateRegistry.getRegistry(host, port);
            boolean bl = validRegistry = registry != null;
            if (validRegistry) {
                try {
                    registry.list();
                }
                catch (ConnectException | NoSuchObjectException connectException) {
                    validRegistry = false;
                }
            }
            if (!validRegistry) {
                if (!(host.equals("localhost") || host.equals("127.0.0.1") || host.equals(InetAddress.getLocalHost().getHostName()) || host.equals(InetAddress.getLocalHost().getHostAddress()))) {
                    throw new AccessException("Cannot create registry on remote host: " + host);
                }
                registry = LocateRegistry.createRegistry(port);
            }
            return registry;
        }
        catch (Exception exception) {
            CategoryLogger.always().error(exception, "RMI exception when locating or creating RMI registry");
            throw new RemoteException("RMI exception when locating or creating RMI registry", exception);
        }
    }

    public static void bind(Registry registry, String bindingKey, Remote object) throws RemoteException, AlreadyBoundException {
        Throw.whenNull(registry, "registry cannot be null");
        Throw.whenNull(bindingKey, "bindingKey cannot be null");
        Throw.when(bindingKey.length() == 0, IllegalArgumentException.class, "bindingKey cannot be the empty String");
        Throw.whenNull(object, "null object cannot be bound");
        try {
            registry.bind(bindingKey, object);
        }
        catch (AlreadyBoundException | RemoteException exception) {
            CategoryLogger.always().error(exception, "RMI exception when binding object to the registry");
            throw exception;
        }
    }

    public static void unbind(Registry registry, String bindingKey) throws RemoteException, NotBoundException {
        Throw.whenNull(registry, "registry cannot be null");
        Throw.whenNull(bindingKey, "bindingKey cannot be null");
        Throw.when(bindingKey.length() == 0, IllegalArgumentException.class, "bindingKey cannot be the empty String");
        try {
            registry.unbind(bindingKey);
        }
        catch (NotBoundException | RemoteException exception) {
            CategoryLogger.always().error(exception, "RMI exception when unbinding object from the registry");
            throw exception;
        }
    }

    public static void rebind(Registry registry, String bindingKey, Remote newObject) throws RemoteException {
        Throw.whenNull(registry, "registry cannot be null");
        Throw.whenNull(bindingKey, "bindingKey cannot be null");
        Throw.when(bindingKey.length() == 0, IllegalArgumentException.class, "bindingKey cannot be the empty String");
        Throw.whenNull(newObject, "null object cannot be bound");
        try {
            registry.rebind(bindingKey, newObject);
        }
        catch (RemoteException exception) {
            CategoryLogger.always().error(exception, "RMI exception when rebinding object to the registry");
            throw exception;
        }
    }

    public static Remote lookup(Registry registry, String bindingKey) throws RemoteException, NotBoundException {
        Throw.whenNull(registry, "registry cannot be null");
        Throw.whenNull(bindingKey, "bindingKey cannot be null");
        Throw.when(bindingKey.length() == 0, IllegalArgumentException.class, "bindingKey cannot be the empty String");
        try {
            return registry.lookup(bindingKey);
        }
        catch (NotBoundException | RemoteException exception) {
            CategoryLogger.always().error(exception, "RMI exception when looking up key {} in the RMI registry", bindingKey);
            throw exception;
        }
    }

    public static void closeRegistry(Registry registry) throws RemoteException {
        Throw.whenNull(registry, "registry cannot be null");
        for (String key : registry.list()) {
            try {
                RmiRegistry.unbind(registry, key);
            }
            catch (NotBoundException | RemoteException nbe) {
                CategoryLogger.always().error(nbe, "RMI exception when unbinding key {} from the RMI registry", key);
            }
        }
        UnicastRemoteObject.unexportObject(registry, true);
    }
}

