/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.reflection;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.djutils.reflection.FieldSignature;

public class MethodSignature
implements Serializable {
    private static final long serialVersionUID = 20191230L;
    private String value = null;

    public MethodSignature(String value) {
        this.value = value;
    }

    public MethodSignature(Method method) {
        Class[] parameterTypes = new Class[]{};
        if (method.getParameterTypes() != null) {
            parameterTypes = method.getParameterTypes();
        }
        this.value = "(";
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.value = this.value + FieldSignature.toDescriptor(parameterTypes[i]);
        }
        this.value = this.value + ")" + FieldSignature.toDescriptor(method.getReturnType());
    }

    public MethodSignature(Constructor<?> constructor) {
        Class[] parameterTypes = new Class[]{};
        if (constructor.getParameterTypes() != null) {
            parameterTypes = constructor.getParameterTypes();
        }
        this.value = "(";
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.value = this.value + FieldSignature.toDescriptor(parameterTypes[i]);
        }
        this.value = this.value + ")" + FieldSignature.toDescriptor(constructor.getDeclaringClass());
    }

    public String getParameterDescriptor() {
        return MethodSignature.getParameterDescriptor(this.value);
    }

    public Class<?>[] getParameterTypes() throws ClassNotFoundException {
        return MethodSignature.getParameterTypes(this.value);
    }

    public String getReturnDescriptor() {
        return MethodSignature.getReturnDescriptor(this.value);
    }

    public Class<?> getReturnType() throws ClassNotFoundException {
        return MethodSignature.getReturnType(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static String getParameterDescriptor(String methodDescriptor) {
        return methodDescriptor.substring(1, methodDescriptor.indexOf(41));
    }

    public static Class<?>[] getParameterTypes(String methodDescriptor) throws ClassNotFoundException {
        String parameterDescriptor = MethodSignature.getParameterDescriptor(methodDescriptor);
        ArrayList result = new ArrayList();
        int length = 0;
        while (length < parameterDescriptor.length()) {
            Object array = "";
            while (parameterDescriptor.charAt(length) == '[') {
                array = (String)array + "[";
                ++length;
            }
            if (parameterDescriptor.charAt(length) == 'L') {
                Object argument = parameterDescriptor.substring(length);
                argument = (String)array + ((String)argument).substring(0, ((String)argument).indexOf(59) + 1);
                result.add(FieldSignature.toClass((String)argument));
                length = length + ((String)argument).length() - ((String)array).length();
                continue;
            }
            result.add(FieldSignature.toClass((String)array + parameterDescriptor.charAt(length)));
            ++length;
        }
        return result.toArray(new Class[result.size()]);
    }

    public static String getReturnDescriptor(String methodDescriptor) {
        return methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
    }

    public static Class<?> getReturnType(String methodDescriptor) throws ClassNotFoundException {
        return FieldSignature.toClass(MethodSignature.getReturnDescriptor(methodDescriptor));
    }
}

