/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.quadtree;

import java.io.Serializable;
import org.djutils.exceptions.Throw;

public class Rectangle
implements Serializable {
    private static final long serialVersionUID = 20200904L;
    private final double left;
    private final double bottom;
    private final double right;
    private final double top;

    public Rectangle(double left, double bottom, double right, double top, boolean check) {
        this(left, bottom, right, top);
        if (check) {
            Throw.when(Double.isNaN(left), IllegalArgumentException.class, "The value of left may not be NaN");
            Throw.when(Double.isNaN(bottom), IllegalArgumentException.class, "The value of bottom may not be NaN");
            Throw.when(Double.isNaN(right), IllegalArgumentException.class, "The value of right may not be NaN");
            Throw.when(Double.isNaN(top), IllegalArgumentException.class, "The value of top may not be NaN");
            Throw.when(left > right, IllegalArgumentException.class, "The value of left may not exceed the value of right");
            Throw.when(bottom > top, IllegalArgumentException.class, "The value of bottom may not exceed the value of top");
        }
    }

    public Rectangle(double left, double bottom, double right, double top) {
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
    }

    public double getLeft() {
        return this.left;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public double getWidth() {
        return this.right - this.left;
    }

    public double getHeight() {
        return this.top - this.bottom;
    }

    public boolean intersects(Rectangle other) {
        return this.left < other.right && this.bottom < other.top && other.left < this.right && other.bottom < this.top;
    }

    public boolean contains(double x, double y) {
        return this.left <= x && x < this.right && this.bottom <= y && y < this.top;
    }

    public boolean contains(Rectangle other) {
        return other.left >= this.left && other.right <= this.right && other.bottom >= this.bottom && other.top <= this.top;
    }

    public String toString() {
        return "Rectangle [LB=" + this.left + "," + this.bottom + ", RT=" + this.right + "," + this.top + "]";
    }
}

