/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.quadtree;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.djutils.exceptions.Throw;
import org.djutils.quadtree.Envelope;
import org.djutils.quadtree.Rectangle;
import org.djutils.quadtree.RectangleAndPayload;

public class QuadTree<T extends Envelope>
implements Collection<T>,
Serializable {
    private static final long serialVersionUID = 20200904L;
    private final int maximumLoad;
    private final double minimumSize;
    private final SubTree<T> tree;
    private int totalSubTrees = 0;

    public QuadTree(int maximumLoad, double minimumSize, double left, double bottom, double right, double top) {
        Throw.when(left >= right, IllegalArgumentException.class, "left (%f) must be less than right (%f)", left, (Object)right);
        Throw.when(bottom >= top, IllegalArgumentException.class, "bottom (%f) must be less than top (%f)", bottom, (Object)top);
        this.maximumLoad = maximumLoad;
        this.minimumSize = minimumSize;
        this.tree = new SubTree(this, new Rectangle(left, bottom, right, top));
    }

    public int getMaxLoad() {
        return this.maximumLoad;
    }

    public double getMinimumSize() {
        return this.minimumSize;
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Envelope)) {
            return false;
        }
        Envelope t = (Envelope)o;
        return this.tree.recursiveContains(new RectangleAndPayload<Envelope>(t.getBoundingRectangle(), t));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.tree.getBoundingBox());
    }

    public Iterator<T> iterator(Rectangle searchArea) {
        return this.collect(searchArea).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.collect(this.tree.getBoundingBox()).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collect(this.tree.getBoundingBox()).toArray(a);
    }

    private Set<T> collect(Rectangle searchArea) {
        Iterator<RectangleAndPayload<T>> iterator = this.tree.recursiveCollect(searchArea).iterator();
        LinkedHashSet<Envelope> result = new LinkedHashSet<Envelope>();
        while (iterator.hasNext()) {
            result.add((Envelope)iterator.next().getPayload());
        }
        return result;
    }

    @Override
    public boolean add(T e) {
        return this.tree.add(new RectangleAndPayload<T>(e.getBoundingRectangle(), e));
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Envelope)) {
            return false;
        }
        Envelope t = (Envelope)o;
        return this.tree.remove(new RectangleAndPayload<Envelope>(t.getBoundingRectangle(), t));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collect(this.tree.getBoundingBox()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (Envelope t : c) {
            result |= this.add((T)t);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not (yet) implemented");
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    void incrementSubTreeCount() {
        ++this.totalSubTrees;
    }

    public int getSubTreeCount() {
        return this.totalSubTrees;
    }

    public String toString() {
        return "QuadTree [maximumLoad=" + this.maximumLoad + ", minimumSize=" + this.minimumSize + ", tree=" + this.tree + "]";
    }

    public String toString(int expandDepth) {
        return "QuadTree [maximumLoad=" + this.maximumLoad + ", minimumSize=" + this.minimumSize + ", tree=" + this.tree.toString(expandDepth) + "]";
    }

    public String dump(String indent) {
        return this.tree.dump(indent);
    }

    class SubTree<T extends Envelope>
    implements Serializable {
        private static final long serialVersionUID = 20200904L;
        private final QuadTree<T> root;
        private final Rectangle boundingBox;
        private int size = 0;
        private SubTree<T>[] children = null;
        private Set<RectangleAndPayload<T>> elements = null;

        SubTree(QuadTree<T> root, Rectangle boundingBox) {
            this.root = root;
            this.boundingBox = boundingBox;
            root.incrementSubTreeCount();
        }

        public final Rectangle getBoundingBox() {
            return this.boundingBox;
        }

        public int size() {
            return this.size;
        }

        public boolean add(RectangleAndPayload<T> e) {
            if (this.contains(e)) {
                return false;
            }
            if (this.elements == null) {
                this.elements = new LinkedHashSet<RectangleAndPayload<T>>();
            }
            this.elements.add(e);
            ++this.size;
            this.reBalance();
            return true;
        }

        public boolean remove(RectangleAndPayload<T> o) {
            if (this.elements.remove(o)) {
                --this.size;
                return true;
            }
            boolean result = false;
            if (this.children != null) {
                Rectangle rectangle = o.getRectangle();
                for (SubTree<T> child : this.children) {
                    if (!child.boundingBox.intersects(rectangle) || !child.remove(o)) continue;
                    result = true;
                }
            }
            if (result) {
                --this.size;
            }
            return result;
        }

        public void clear() {
            this.elements.clear();
            this.children = null;
            this.size = 0;
        }

        public boolean contains(RectangleAndPayload<T> o) {
            if (this.elements == null) {
                return false;
            }
            return this.recursiveContains(o);
        }

        boolean recursiveContains(RectangleAndPayload<T> o) {
            if (!this.boundingBox.intersects(o.getRectangle()) || this.elements == null) {
                return false;
            }
            for (RectangleAndPayload<T> element : this.elements) {
                if (!element.equals(o)) continue;
                return true;
            }
            if (this.children == null) {
                return false;
            }
            for (SubTree<T> child : this.children) {
                if (!child.recursiveContains(o)) continue;
                return true;
            }
            return false;
        }

        public Set<RectangleAndPayload<T>> recursiveCollect(Rectangle rectangle) {
            LinkedHashSet<RectangleAndPayload<T>> result = new LinkedHashSet<RectangleAndPayload<T>>();
            if (!this.boundingBox.intersects(rectangle)) {
                return result;
            }
            if (this.elements != null) {
                for (RectangleAndPayload rectangleAndPayload : this.elements) {
                    if (!rectangleAndPayload.getRectangle().intersects(rectangle)) continue;
                    result.add(rectangleAndPayload);
                }
            }
            if (this.children != null) {
                for (SubTree<T> child : this.children) {
                    result.addAll(child.recursiveCollect(rectangle));
                }
            }
            return result;
        }

        private void reBalance() {
            if (this.elements.size() < this.root.getMaxLoad() || this.boundingBox.getWidth() < this.root.getMinimumSize() || this.boundingBox.getHeight() < this.root.getMinimumSize()) {
                return;
            }
            double cX = (this.boundingBox.getLeft() + this.boundingBox.getRight()) / 2.0;
            double cY = (this.boundingBox.getBottom() + this.boundingBox.getTop()) / 2.0;
            int canMove = 0;
            canMove = this.elements.size();
            if (canMove == 0 || canMove < this.root.getMaxLoad() && this.children == null) {
                return;
            }
            if (this.children == null) {
                this.children = new SubTree[]{new SubTree<T>(this.root, new Rectangle(this.boundingBox.getLeft(), this.boundingBox.getBottom(), cX, cY)), new SubTree<T>(this.root, new Rectangle(cX, this.boundingBox.getBottom(), this.boundingBox.getRight(), cY)), new SubTree<T>(this.root, new Rectangle(this.boundingBox.getLeft(), cY, cX, this.boundingBox.getTop())), new SubTree<T>(this.root, new Rectangle(cX, cY, this.boundingBox.getRight(), this.boundingBox.getTop()))};
            }
            Iterator<RectangleAndPayload<T>> iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                RectangleAndPayload<T> e = iterator.next();
                if (e.getRectangle().contains(this.boundingBox)) continue;
                boolean added = false;
                for (SubTree<T> child : this.children) {
                    if (!e.getRectangle().intersects(child.boundingBox)) continue;
                    added |= child.add(e);
                }
                if (added) {
                    iterator.remove();
                    continue;
                }
                System.out.println("ERROR: Could not add " + e + " to any of the children");
            }
        }

        public String toString() {
            return "SubTree [boundingBox=" + this.boundingBox + ", size=" + this.size + ", children=" + this.children + (String)(this.elements == null ? "elements=null" : ", elements.size=" + this.elements.size()) + "]";
        }

        public String toString(int expandDepth) {
            if (expandDepth > 0) {
                return "SubTree [boundingBox=" + this.boundingBox + ", size=" + this.size + ", children=" + (String)(this.children != null ? "[SW:" + this.children[0].toString(expandDepth - 1) + ", SE:" + this.children[1].toString(expandDepth - 1) + ", NW:" + this.children[2].toString(expandDepth - 1) + ", NE:" + this.children[3].toString(expandDepth - 1) + "]" : "null") + ", elements.size=" + this.elements.size() + "]";
            }
            return this.toString();
        }

        public String dump(String indent) {
            StringBuilder result = new StringBuilder();
            result.append(indent);
            result.append("SubTree [size=");
            result.append(this.size);
            result.append("] ");
            result.append(this.boundingBox);
            result.append("\n");
            String subIndent = indent + "    ";
            Iterator<RectangleAndPayload<T>> iterator = this.elements.iterator();
            for (int i = 0; i < this.elements.size(); ++i) {
                result.append(subIndent);
                result.append(i);
                result.append(" ");
                result.append(iterator.next());
                result.append("\n");
            }
            if (this.children != null) {
                result.append(subIndent);
                result.append("SW");
                result.append("\n");
                result.append(this.children[0].dump(subIndent));
                result.append(subIndent);
                result.append("SE");
                result.append("\n");
                result.append(this.children[1].dump(subIndent));
                result.append(subIndent);
                result.append("NW");
                result.append("\n");
                result.append(this.children[2].dump(subIndent));
                result.append(subIndent);
                result.append("NE");
                result.append("\n");
                result.append(this.children[3].dump(subIndent));
            }
            return result.toString();
        }
    }
}

