/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.profile;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.djutils.exceptions.Throw;

public final class Profile {
    private static final Map<String, ProfileInfo> INFOS = new LinkedHashMap<String, ProfileInfo>();
    private static final Map<String, String> LINES = new LinkedHashMap<String, String>();
    private static long printInterval = 1000L;
    private static long lastPrint = 0L;

    private Profile() {
    }

    public static void start() {
        Profile.start0(null, System.nanoTime());
    }

    public static void start(String name) {
        Profile.start0(name, System.nanoTime());
    }

    private static void start0(String name, Long nanoTime) {
        Profile.getProfileInfo(name, true).start(nanoTime);
    }

    public static void end() {
        Profile.end0(null, System.nanoTime());
    }

    public static void end(String name) {
        Profile.end0(name, System.nanoTime());
    }

    private static void end0(String name, Long nanoTime) {
        Profile.getProfileInfo(name, false).end(nanoTime);
    }

    private static ProfileInfo getProfileInfo(String name, boolean start) {
        Object partId;
        StackTraceElement element = Thread.currentThread().getStackTrace()[4];
        String classMethodId = element.getClassName() + ":" + element.getMethodName();
        if (name == null) {
            if (start) {
                partId = ":" + String.valueOf(element.getLineNumber());
                LINES.put(classMethodId, (String)partId);
            } else {
                partId = LINES.get(classMethodId);
            }
        } else {
            partId = ":" + name;
        }
        classMethodId = classMethodId + (String)partId;
        ProfileInfo info = INFOS.get(classMethodId);
        if (info == null) {
            info = new ProfileInfo(name);
            INFOS.put(classMethodId, info);
        }
        return info;
    }

    public static String statistics() {
        double sum = 0.0;
        int maxInvocations = 0;
        int maxNameLength = 4;
        TreeMap sorted = new TreeMap(Collections.reverseOrder());
        for (Map.Entry<String, ProfileInfo> entry : INFOS.entrySet()) {
            String id = entry.getKey();
            ProfileInfo info = INFOS.get(id);
            sorted.put(info.getTotal(), entry);
            sum += info.getTotal();
            maxInvocations = maxInvocations > info.getInvocations() ? maxInvocations : info.getInvocations();
            int nameLength = (info.getName() == null ? id : info.getName()).length();
            maxNameLength = maxNameLength > nameLength ? maxNameLength : nameLength;
        }
        int lengthInvoke = String.valueOf(maxInvocations).length();
        lengthInvoke = lengthInvoke > 6 ? lengthInvoke : 6;
        String invokeHeaderFormat = String.format("%%%d.%ds", lengthInvoke, lengthInvoke);
        String invokeLineFormat = String.format("%%%ds", lengthInvoke);
        String nameHeaderFormat = String.format("%%%d.%ds", maxNameLength, maxNameLength);
        String nameLineFormat = String.format("%%%ds", maxNameLength);
        String line = new String(new char[80 + lengthInvoke + maxNameLength]).replace("\u0000", "-");
        StringBuilder builder = new StringBuilder();
        builder.append("-").append(line).append("-\n");
        builder.append(String.format("| %7.7s | ", "Perc."));
        builder.append(String.format(invokeHeaderFormat, "#Calls"));
        builder.append(String.format(" | %10.10s | %10.10s | %10.10s | %10.10s | %10.10s | ", "TotTime", "MinTime", "MaxTime", "AvgTime", "StdTime"));
        builder.append(String.format(nameHeaderFormat, "Name")).append(" |\n");
        builder.append("|").append(line).append("|\n");
        for (Map.Entry entry : sorted.values()) {
            String id = (String)entry.getKey();
            ProfileInfo info = (ProfileInfo)entry.getValue();
            if (info.getInvocations() <= 0) continue;
            double perc = 100.0 * info.getTotal() / sum;
            builder.append(String.format("| %6.2f%% | ", perc));
            builder.append(String.format(invokeLineFormat, info.getInvocations()));
            builder.append(String.format(" | %9.4fs | %9.6fs | %9.6fs | %9.6fs | ", info.getTotal(), info.getMin(), info.getMax(), info.getMean()));
            if (info.getInvocations() > 1) {
                builder.append(String.format("%9.6fs", info.getStandardDeviation()));
            } else {
                builder.append("          ");
            }
            builder.append(" | ").append(String.format(nameLineFormat, info.getName() == null ? id : info.getName())).append(" |\n");
        }
        return builder.append("-").append(line).append("-\n").toString();
    }

    public static String statistics(String name) {
        Throw.whenNull(name, "name may not be null");
        for (ProfileInfo result : INFOS.values()) {
            if (null == result) {
                return null;
            }
            if (!name.equals(result.getName())) continue;
            return result.toString();
        }
        return null;
    }

    public static void print() {
        long t = System.currentTimeMillis();
        if (t - lastPrint > printInterval) {
            lastPrint = t;
            System.out.print(Profile.statistics());
        }
    }

    public static void setPrintInterval(long printInterval) {
        Profile.printInterval = printInterval;
    }

    public static void clear() {
        INFOS.clear();
        LINES.clear();
    }

    public static void reset() {
        for (ProfileInfo pi : INFOS.values()) {
            pi.reset();
        }
    }

    private static class ProfileInfo {
        private static final double NANOSECONDSPERSECOND = 1.0E9;
        private final String name;
        private Long start = null;
        private long total;
        private long totalSquared;
        private long minTime;
        private long maxTime;
        private int invocations;

        ProfileInfo(String name) {
            this.name = name;
        }

        public void reset() {
            this.start = null;
            this.total = 0L;
            this.totalSquared = 0L;
            this.minTime = 0L;
            this.maxTime = 0L;
            this.invocations = 0;
        }

        public void start(long startTime) {
            Throw.when(this.start != null, IllegalStateException.class, "Can not start profiling because it is already running.");
            this.start = startTime;
        }

        public void end(long endTime) {
            Throw.when(this.start == null, IllegalStateException.class, "Can not end profiling because it is not running.");
            long duration = endTime - this.start;
            this.total += duration;
            this.totalSquared += duration * duration;
            if (this.invocations == 0) {
                this.minTime = duration;
                this.maxTime = duration;
            } else {
                this.minTime = this.minTime < duration ? this.minTime : duration;
                this.maxTime = this.maxTime > duration ? this.maxTime : duration;
            }
            ++this.invocations;
            this.start = null;
        }

        public String getName() {
            return this.name;
        }

        public double getTotal() {
            return (double)this.total / 1.0E9;
        }

        public double getStandardDeviation() {
            if (this.invocations < 2) {
                return Double.NaN;
            }
            double squared = this.totalSquared - this.total * this.total / (long)this.invocations;
            return Math.sqrt(squared / (double)(this.invocations - 1)) / 1.0E9;
        }

        public int getInvocations() {
            return this.invocations;
        }

        public double getMean() {
            return this.getTotal() / (double)this.getInvocations();
        }

        public double getMin() {
            return (double)this.minTime / 1.0E9;
        }

        public double getMax() {
            return (double)this.maxTime / 1.0E9;
        }

        public String toString() {
            return "ProfileInfo [name=" + this.name + ", start=" + this.start + ", total=" + this.total + ", totalSquared=" + this.totalSquared + ", minTime=" + this.minTime + ", maxTime=" + this.maxTime + ", invocations=" + this.invocations + "]";
        }
    }
}

