/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.multikeymap;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.djutils.exceptions.Throw;

public class MultiKeyMap<T> {
    private final Class<?>[] keyTypes;
    private final Map<Object, Object> map = new LinkedHashMap<Object, Object>();

    public MultiKeyMap(Class<?> ... keyTypes) {
        Throw.when(keyTypes.length < 1, IllegalArgumentException.class, "keyTypes may not be empty");
        this.keyTypes = keyTypes;
    }

    public T get(Supplier<T> supplier, Object ... keys) {
        return this.getValue(supplier, Arrays.asList(keys));
    }

    public T get(Object ... keys) {
        return this.getValue(null, Arrays.asList(keys));
    }

    public MultiKeyMap<T> getSubMap(Object ... keys) {
        Throw.when(keys.length >= this.keyTypes.length, IllegalArgumentException.class, "Too many keys");
        return this.getSubMap(false, Arrays.asList(keys));
    }

    public T put(T newValue, Object ... keys) {
        List<Object> keyList = Arrays.asList(keys);
        Map<Object, T> branch = this.getFinalMap(true, keyList);
        Object key = this.getFinalKey(keyList);
        return branch.put(key, newValue);
    }

    private Object getFinalKey(List<Object> keys) {
        Object key = keys.get(keys.size() - 1);
        Throw.whenNull(key, "key may not be null");
        Throw.when(key != null && !this.keyTypes[keys.size() - 1].isAssignableFrom(key.getClass()), IllegalArgumentException.class, "Key %s is not of %s.", key, this.keyTypes[keys.size() - 1]);
        return key;
    }

    private Map<Object, T> getFinalMap(boolean createBranches, List<Object> keys) {
        Throw.when(keys.size() != this.keyTypes.length, IllegalArgumentException.class, "Incorrect number of keys.");
        MultiKeyMap<T> finalMap = this.getSubMap(createBranches, keys.subList(0, keys.size() - 1));
        if (null == finalMap) {
            return null;
        }
        return finalMap.map;
    }

    private T getValue(Supplier<T> supplier, List<Object> keys) {
        Throw.when(keys.size() != this.keyTypes.length, IllegalArgumentException.class, "Wrong number of keys");
        Map<Object, T> branch = this.getFinalMap(null != supplier, keys);
        if (null == branch) {
            return null;
        }
        Object key = this.getFinalKey(keys);
        T leaf = branch.get(key);
        if (leaf == null) {
            if (null == supplier) {
                return null;
            }
            leaf = supplier.get();
            branch.put(key, leaf);
        }
        return leaf;
    }

    public Set<Object> getKeys(Object ... keys) {
        return this.getSubMap((boolean)false, Arrays.asList(keys)).map.keySet();
    }

    private MultiKeyMap<T> getSubMap(boolean createMissingBranches, List<Object> keys) {
        if (keys.size() == 0) {
            return this;
        }
        Throw.when(keys.size() > this.keyTypes.length, IllegalArgumentException.class, "Too many keys");
        Throw.when(keys.get(0) != null && !this.keyTypes[0].isAssignableFrom(keys.get(0).getClass()), IllegalArgumentException.class, "Key %s is not of %s.", keys.get(0), this.keyTypes[0]);
        MultiKeyMap<T> subMap = (MultiKeyMap<T>)this.map.get(keys.get(0));
        if (null == subMap && !createMissingBranches) {
            return null;
        }
        if (null == subMap) {
            Class[] subTypes = new Class[this.keyTypes.length - 1];
            System.arraycopy(this.keyTypes, 1, subTypes, 0, this.keyTypes.length - 1);
            subMap = new MultiKeyMap<T>(subTypes);
            this.map.put(keys.get(0), subMap);
        }
        return subMap.getSubMap(createMissingBranches, keys.subList(1, keys.size()));
    }

    public Object clear(Object ... keys) {
        return this.clear(Arrays.asList(keys));
    }

    private Object clear(List<Object> keys) {
        if (keys.size() == 0) {
            this.map.clear();
            return this;
        }
        MultiKeyMap<T> subMap = this.getSubMap(false, keys.subList(0, keys.size() - 1));
        if (null == subMap) {
            return null;
        }
        if (keys.size() == this.keyTypes.length) {
            Map<Object, Object> endMap = subMap.map;
            return endMap.remove(keys.get(keys.size() - 1));
        }
        return subMap.map.remove(keys.get(keys.size() - 1));
    }

    public String toString() {
        return "MultiKeyMap [types=" + Arrays.toString(this.keyTypes) + ", map=" + this.map + "]";
    }
}

