/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class CompressedFileWriter
implements AutoCloseable {
    private final ZipOutputStream zipOutputStream;
    private BufferedWriter bufferedWriter;

    public CompressedFileWriter(String file) throws FileNotFoundException {
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream((String)(file.toLowerCase().endsWith(".zip") ? file : file + ".zip")));
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.zipOutputStream));
    }

    public BufferedWriter next(String name) throws IOException {
        this.bufferedWriter.flush();
        this.zipOutputStream.putNextEntry(new ZipEntry(name));
        return this.bufferedWriter;
    }

    @Override
    public void close() throws IOException {
        this.bufferedWriter.flush();
        this.zipOutputStream.close();
    }

    public static BufferedWriter create(String filePath, boolean zipped) throws IOException {
        if (zipped) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream((String)(filePath.toLowerCase().endsWith(".zip") ? filePath : filePath + ".zip")));
            String fileName = new File(filePath).getName();
            fileName = fileName.toLowerCase().endsWith(".zip") ? fileName.substring(0, fileName.length() - 4) : fileName;
            zipOutputStream.putNextEntry(new ZipEntry(fileName));
            return new BufferedWriter(new OutputStreamWriter(zipOutputStream));
        }
        return new BufferedWriter(new FileWriter(filePath));
    }
}

