/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractSet;
import org.djutils.immutablecollections.ImmutableIterator;
import org.djutils.immutablecollections.ImmutableNavigableSet;
import org.djutils.immutablecollections.ImmutableSortedSet;

public class ImmutableTreeSet<E>
extends ImmutableAbstractSet<E>
implements ImmutableNavigableSet<E> {
    private static final long serialVersionUID = 20160507L;

    public ImmutableTreeSet(Collection<? extends E> sortedSet) {
        super(new TreeSet<E>(sortedSet), Immutable.COPY);
    }

    public ImmutableTreeSet(NavigableSet<E> treeSet, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new TreeSet(treeSet) : treeSet, copyOrWrap);
    }

    public ImmutableTreeSet(ImmutableAbstractSet<E> immutableSortedSet) {
        super(new TreeSet(immutableSortedSet.getUnderlyingCollection()), Immutable.COPY);
    }

    public ImmutableTreeSet(ImmutableTreeSet<E> immutableTreeSet, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new TreeSet(immutableTreeSet.getUnderlyingCollection()) : immutableTreeSet.getUnderlyingCollection(), copyOrWrap);
    }

    @Override
    public final NavigableSet<E> toSet() {
        return new TreeSet(this.getUnderlyingCollection());
    }

    @Override
    protected NavigableSet<E> getUnderlyingCollection() {
        return (NavigableSet)super.getUnderlyingCollection();
    }

    @Override
    public final Comparator<? super E> comparator() {
        return this.getUnderlyingCollection().comparator();
    }

    @Override
    public final ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        return new ImmutableTreeSet<E>((TreeSet)this.getUnderlyingCollection().subSet(fromElement, toElement), Immutable.WRAP);
    }

    @Override
    public final ImmutableSortedSet<E> headSet(E toElement) {
        return new ImmutableTreeSet<E>((TreeSet)this.getUnderlyingCollection().headSet(toElement), Immutable.WRAP);
    }

    @Override
    public final ImmutableSortedSet<E> tailSet(E fromElement) {
        return new ImmutableTreeSet<E>((TreeSet)this.getUnderlyingCollection().tailSet(fromElement), Immutable.WRAP);
    }

    @Override
    public final E first() {
        return this.getUnderlyingCollection().first();
    }

    @Override
    public final E last() {
        return this.getUnderlyingCollection().last();
    }

    @Override
    public final E lower(E e) {
        return this.getUnderlyingCollection().lower(e);
    }

    @Override
    public final E floor(E e) {
        return this.getUnderlyingCollection().floor(e);
    }

    @Override
    public final E ceiling(E e) {
        return this.getUnderlyingCollection().ceiling(e);
    }

    @Override
    public final E higher(E e) {
        return this.getUnderlyingCollection().higher(e);
    }

    @Override
    public final ImmutableNavigableSet<E> descendingSet() {
        return new ImmutableTreeSet(this.getUnderlyingCollection().descendingSet());
    }

    @Override
    public final ImmutableIterator<E> descendingIterator() {
        return new ImmutableIterator(this.getUnderlyingCollection().descendingIterator());
    }

    @Override
    public final ImmutableNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new ImmutableTreeSet<E>(this.getUnderlyingCollection().subSet(fromElement, fromInclusive, toElement, toInclusive), Immutable.WRAP);
    }

    @Override
    public final ImmutableNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new ImmutableTreeSet<E>(this.getUnderlyingCollection().headSet(toElement, inclusive), Immutable.WRAP);
    }

    @Override
    public final ImmutableNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new ImmutableTreeSet<E>(this.getUnderlyingCollection().tailSet(fromElement, inclusive), Immutable.WRAP);
    }

    @Override
    public final String toString() {
        Set set = this.getUnderlyingCollection();
        if (null == set) {
            return "ImmutableTreeSet []";
        }
        return "ImmutableTreeSet [" + set.toString() + "]";
    }
}

