/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractMap;
import org.djutils.immutablecollections.ImmutableMap;
import org.djutils.immutablecollections.ImmutableNavigableMap;
import org.djutils.immutablecollections.ImmutableNavigableSet;
import org.djutils.immutablecollections.ImmutableSortedMap;
import org.djutils.immutablecollections.ImmutableSortedSet;
import org.djutils.immutablecollections.ImmutableTreeSet;

public class ImmutableTreeMap<K, V>
extends ImmutableAbstractMap<K, V>
implements ImmutableNavigableMap<K, V> {
    private static final long serialVersionUID = 20160507L;
    private ImmutableSortedSet<K> cachedKeySet = null;
    private ImmutableSortedSet<ImmutableMap.ImmutableEntry<K, V>> cachedEntrySet = null;

    public ImmutableTreeMap(Map<K, V> sortedMap) {
        super(new TreeMap<K, V>(sortedMap), Immutable.COPY);
    }

    public ImmutableTreeMap(NavigableMap<K, V> map, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new TreeMap(map) : map, copyOrWrap);
    }

    public ImmutableTreeMap(ImmutableAbstractMap<K, V> immutableMap) {
        super(new TreeMap<K, V>(immutableMap.getUnderlyingMap()), Immutable.COPY);
    }

    public ImmutableTreeMap(ImmutableTreeMap<K, V> immutableTreeMap, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new TreeMap(immutableTreeMap.getUnderlyingMap()) : immutableTreeMap.getUnderlyingMap(), copyOrWrap);
    }

    @Override
    protected final NavigableMap<K, V> getUnderlyingMap() {
        return (NavigableMap)super.getUnderlyingMap();
    }

    @Override
    public final NavigableMap<K, V> toMap() {
        return new TreeMap(super.getUnderlyingMap());
    }

    @Override
    public final ImmutableSortedSet<K> keySet() {
        if (this.cachedKeySet == null) {
            TreeSet immutableKeySet = new TreeSet(this.getUnderlyingMap().comparator());
            immutableKeySet.addAll(this.getUnderlyingMap().keySet());
            this.cachedKeySet = new ImmutableTreeSet(immutableKeySet, Immutable.WRAP);
        }
        return this.cachedKeySet;
    }

    @Override
    public ImmutableSortedSet<ImmutableMap.ImmutableEntry<K, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            TreeSet immutableEntrySet = new TreeSet(new Comparator<ImmutableMap.ImmutableEntry<K, V>>(){

                @Override
                public int compare(ImmutableMap.ImmutableEntry<K, V> o1, ImmutableMap.ImmutableEntry<K, V> o2) {
                    return ((Comparable)o1.getKey()).compareTo(o2.getKey());
                }
            });
            for (Map.Entry entry : this.getUnderlyingMap().entrySet()) {
                immutableEntrySet.add(new ImmutableMap.ImmutableEntry(entry));
            }
            this.cachedEntrySet = new ImmutableTreeSet<ImmutableMap.ImmutableEntry<K, V>>(immutableEntrySet, Immutable.WRAP);
        }
        return this.cachedEntrySet;
    }

    @Override
    public ImmutableSortedSet<V> values() {
        if (this.cachedValues == null) {
            TreeSet immutableValues = new TreeSet(this.getUnderlyingMap().values());
            this.cachedValues = new ImmutableTreeSet(immutableValues, Immutable.WRAP);
        }
        return (ImmutableNavigableSet)this.cachedValues;
    }

    @Override
    public final Comparator<? super K> comparator() {
        return this.getUnderlyingMap().comparator();
    }

    @Override
    public final ImmutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        return new ImmutableTreeMap(this.getUnderlyingMap().subMap(fromKey, toKey));
    }

    @Override
    public final ImmutableSortedMap<K, V> headMap(K toKey) {
        return new ImmutableTreeMap(this.getUnderlyingMap().headMap(toKey));
    }

    @Override
    public final ImmutableSortedMap<K, V> tailMap(K fromKey) {
        return new ImmutableTreeMap(this.getUnderlyingMap().tailMap(fromKey));
    }

    @Override
    public final K firstKey() {
        return this.getUnderlyingMap().firstKey();
    }

    @Override
    public final K lastKey() {
        return this.getUnderlyingMap().lastKey();
    }

    @Override
    public final K lowerKey(K key) {
        return this.getUnderlyingMap().lowerKey(key);
    }

    @Override
    public final K floorKey(K key) {
        return this.getUnderlyingMap().floorKey(key);
    }

    @Override
    public final K ceilingKey(K key) {
        return this.getUnderlyingMap().ceilingKey(key);
    }

    @Override
    public final K higherKey(K key) {
        return this.getUnderlyingMap().higherKey(key);
    }

    @Override
    public final ImmutableNavigableMap<K, V> descendingMap() {
        return new ImmutableTreeMap(this.getUnderlyingMap().descendingMap());
    }

    @Override
    public final ImmutableNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new ImmutableTreeMap(this.getUnderlyingMap().subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    public final ImmutableNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new ImmutableTreeMap(this.getUnderlyingMap().headMap(toKey, inclusive));
    }

    @Override
    public final ImmutableNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new ImmutableTreeMap(this.getUnderlyingMap().tailMap(fromKey, inclusive));
    }

    @Override
    public final String toString() {
        Map map = this.getUnderlyingMap();
        if (null == map) {
            return "ImmutableTreeMap []";
        }
        return "ImmutableTreeMap [" + map.toString() + "]";
    }
}

