/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.LinkedHashSet;
import java.util.Set;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableLinkedHashSet;

public interface ImmutableSet<E>
extends ImmutableCollection<E> {
    public Set<E> toSet();

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public String toString();

    public static <E> ImmutableSet<E> of() {
        return new ImmutableLinkedHashSet(new LinkedHashSet(), Immutable.WRAP);
    }

    public static <E> ImmutableSet<E> of(E v1) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.add(v1);
        return new ImmutableLinkedHashSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSet<E> of(E v1, E v2) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.add(v1);
        set.add(v2);
        return new ImmutableLinkedHashSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSet<E> of(E v1, E v2, E v3) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        return new ImmutableLinkedHashSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSet<E> of(E v1, E v2, E v3, E v4) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        return new ImmutableLinkedHashSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSet<E> of(E v1, E v2, E v3, E v4, E v5, E ... vn) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        set.add(v5);
        for (E v : vn) {
            set.add(v);
        }
        return new ImmutableLinkedHashSet(set, Immutable.WRAP);
    }
}

