/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractMap;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableHashSet;
import org.djutils.immutablecollections.ImmutableLinkedHashSet;
import org.djutils.immutablecollections.ImmutableMap;
import org.djutils.immutablecollections.ImmutableSet;

public class ImmutableLinkedHashMap<K, V>
extends ImmutableAbstractMap<K, V> {
    private static final long serialVersionUID = 20160507L;
    private ImmutableSet<K> cachedKeySet = null;
    private ImmutableSet<ImmutableMap.ImmutableEntry<K, V>> cachedEntrySet = null;

    public ImmutableLinkedHashMap(Map<K, V> map) {
        super(new LinkedHashMap<K, V>(map), Immutable.COPY);
    }

    public ImmutableLinkedHashMap(Map<K, V> map, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new LinkedHashMap(map) : map, copyOrWrap);
    }

    public ImmutableLinkedHashMap(ImmutableAbstractMap<K, V> immutableMap) {
        super(new LinkedHashMap<K, V>(immutableMap.getUnderlyingMap()), Immutable.COPY);
    }

    public ImmutableLinkedHashMap(ImmutableAbstractMap<K, V> immutableMap, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new LinkedHashMap<K, V>(immutableMap.getUnderlyingMap()) : immutableMap.getUnderlyingMap(), copyOrWrap);
    }

    @Override
    protected final Map<K, V> getUnderlyingMap() {
        return super.getUnderlyingMap();
    }

    @Override
    public final Map<K, V> toMap() {
        return new LinkedHashMap<K, V>(this.getUnderlyingMap());
    }

    @Override
    public final ImmutableSet<K> keySet() {
        if (this.cachedKeySet == null) {
            LinkedHashSet<K> immutableKeySet = new LinkedHashSet<K>(this.getUnderlyingMap().keySet());
            this.cachedKeySet = new ImmutableHashSet<K>(immutableKeySet, Immutable.WRAP);
        }
        return this.cachedKeySet;
    }

    @Override
    public ImmutableSet<ImmutableMap.ImmutableEntry<K, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            LinkedHashSet<ImmutableMap.ImmutableEntry<K, V>> immutableEntrySet = new LinkedHashSet<ImmutableMap.ImmutableEntry<K, V>>();
            for (Map.Entry<K, V> entry : this.getUnderlyingMap().entrySet()) {
                immutableEntrySet.add(new ImmutableMap.ImmutableEntry<K, V>(entry));
            }
            this.cachedEntrySet = new ImmutableHashSet<ImmutableMap.ImmutableEntry<K, V>>(immutableEntrySet, Immutable.WRAP);
        }
        return this.cachedEntrySet;
    }

    @Override
    public ImmutableCollection<V> values() {
        if (this.cachedValues == null) {
            LinkedHashSet<V> immutableValues = new LinkedHashSet<V>(this.getUnderlyingMap().values());
            this.cachedValues = new ImmutableLinkedHashSet<V>(immutableValues, Immutable.WRAP);
        }
        return this.cachedValues;
    }

    @Override
    public final String toString() {
        Map<K, V> map = this.getUnderlyingMap();
        if (null == map) {
            return "ImmutableLinkedHashMap []";
        }
        return "ImmutableLinkedHashMap [" + map.toString() + "]";
    }
}

