/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractCollection;
import org.djutils.immutablecollections.ImmutableAbstractSet;

public class ImmutableHashSet<E>
extends ImmutableAbstractSet<E> {
    private static final long serialVersionUID = 20160507L;

    public ImmutableHashSet(Collection<? extends E> collection) {
        super(new HashSet<E>(collection), Immutable.COPY);
    }

    public ImmutableHashSet(Set<E> set, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new HashSet(set) : set, copyOrWrap);
    }

    public ImmutableHashSet(ImmutableAbstractCollection<? extends E> collection) {
        super(new HashSet<E>(collection.getUnderlyingCollection()), Immutable.COPY);
    }

    public ImmutableHashSet(ImmutableAbstractSet<E> set, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new HashSet(set.getUnderlyingCollection()) : set.getUnderlyingCollection(), copyOrWrap);
    }

    @Override
    protected Set<E> getUnderlyingCollection() {
        return super.getUnderlyingCollection();
    }

    @Override
    public final Set<E> toSet() {
        return new HashSet(this.getUnderlyingCollection());
    }

    @Override
    public String toString() {
        Collection set = this.getUnderlyingCollection();
        if (null == set) {
            return "ImmutableHashSet []";
        }
        return "ImmutableHashSet [" + set.toString() + "]";
    }
}

