/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractCollection;
import org.djutils.immutablecollections.ImmutableAbstractList;
import org.djutils.immutablecollections.ImmutableList;

public class ImmutableArrayList<E>
extends ImmutableAbstractList<E> {
    private static final long serialVersionUID = 20160507L;

    public ImmutableArrayList(Collection<? extends E> collection) {
        super(new ArrayList<E>(collection), Immutable.COPY);
    }

    public ImmutableArrayList(List<E> list, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new ArrayList(list) : list, copyOrWrap);
    }

    public ImmutableArrayList(ImmutableAbstractCollection<? extends E> collection) {
        super(new ArrayList<E>(collection.getUnderlyingCollection()), Immutable.COPY);
    }

    public ImmutableArrayList(ImmutableAbstractList<E> list, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new ArrayList(list.getUnderlyingCollection()) : list.getUnderlyingCollection(), copyOrWrap);
    }

    @Override
    public final ArrayList<E> toList() {
        return new ArrayList(this.getUnderlyingCollection());
    }

    @Override
    protected List<E> getUnderlyingCollection() {
        return super.getUnderlyingCollection();
    }

    @Override
    public final ImmutableList<E> subList(int fromIndex, int toIndex) {
        return new ImmutableArrayList(this.getUnderlyingCollection().subList(fromIndex, toIndex));
    }

    @Override
    public final String toString() {
        Collection list = this.getUnderlyingCollection();
        if (null == list) {
            return "ImmutableArrayList []";
        }
        return "ImmutableArrayList [" + list.toString() + "]";
    }
}

