/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.LinkedHashSet;
import java.util.Map;
import org.djutils.exceptions.Throw;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableHashSet;
import org.djutils.immutablecollections.ImmutableMap;

public abstract class ImmutableAbstractMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = 20160507L;
    private final Map<K, V> map;
    protected final Immutable copyOrWrap;
    protected ImmutableCollection<V> cachedValues = null;

    protected ImmutableAbstractMap(Map<K, V> map, Immutable copyOrWrap) {
        Throw.whenNull(copyOrWrap, "the copyOrWrap argument should be Immutable.COPY or Immutable.WRAP");
        this.copyOrWrap = copyOrWrap;
        Throw.whenNull(map, "the map argument cannot be null");
        this.map = map;
    }

    protected Map<K, V> getUnderlyingMap() {
        return this.map;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public ImmutableCollection<V> values() {
        if (this.cachedValues == null) {
            LinkedHashSet<V> immutableValues = new LinkedHashSet<V>(this.getUnderlyingMap().values());
            this.cachedValues = new ImmutableHashSet<V>(immutableValues, Immutable.WRAP);
        }
        return this.cachedValues;
    }

    @Override
    public final boolean isWrap() {
        return this.copyOrWrap.isWrap();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableAbstractMap other = (ImmutableAbstractMap)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

