/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.djutils.exceptions.Throw;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractCollection;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableIterator;
import org.djutils.immutablecollections.ImmutableList;

public abstract class ImmutableAbstractList<E>
extends ImmutableAbstractCollection<E>
implements ImmutableList<E>,
RandomAccess {
    private static final long serialVersionUID = 20160507L;
    private final List<E> list;

    protected ImmutableAbstractList(List<E> list, Immutable copyOrWrap) {
        super(copyOrWrap);
        Throw.whenNull(list, "the list argument cannot be null");
        this.list = list;
    }

    @Override
    public final Collection<E> toCollection() {
        return this.toList();
    }

    @Override
    protected List<E> getUnderlyingCollection() {
        return this.list;
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public final int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public final Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public final E get(int index) {
        return this.list.get(index);
    }

    @Override
    public final ImmutableIterator<E> iterator() {
        return new ImmutableIterator<E>(this.list.iterator());
    }

    @Override
    public final void forEach(Consumer<? super E> action) {
        this.list.forEach(action);
    }

    @Override
    public final Spliterator<E> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public final boolean containsAll(ImmutableCollection<?> c) {
        return this.list.containsAll(c.toCollection());
    }

    @Override
    public final Stream<E> stream() {
        return this.list.stream();
    }

    @Override
    public final Stream<E> parallelStream() {
        return this.list.parallelStream();
    }

    @Override
    public final boolean isWrap() {
        return this.copyOrWrap.isWrap();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableAbstractList other = (ImmutableAbstractList)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }
}

