/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.djutils.event.EventType;
import org.djutils.event.LocalEventProducer;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.MetaData;
import org.djutils.metadata.ObjectDescriptor;

public class EventProducingMap<K, V>
extends LocalEventProducer
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 20191230L;
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT", new MetaData("Size of the map after add", "Size of the map", new ObjectDescriptor("Size of the map after add", "Size of the map", Integer.class)));
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT", new MetaData("Size of the map after remove", "Size of the map", new ObjectDescriptor("Size of the map after remove", "Size of the map", Integer.class)));
    public static final EventType OBJECT_CHANGED_EVENT = new EventType("OBJECT_CHANGED_EVENT", new MetaData("Size of the map after change", "Size of the map", new ObjectDescriptor("Size of the map after change", "Size of the map", Integer.class)));
    private final Map<K, V> wrappedMap;

    public EventProducingMap(Map<K, V> wrappedMap) {
        Throw.whenNull(wrappedMap, "wrappedMap cannot be null");
        this.wrappedMap = wrappedMap;
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        int nr = this.wrappedMap.size();
        V result = this.wrappedMap.put(key, value);
        if (nr != this.wrappedMap.size()) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedMap.size()));
        } else {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedMap.size()));
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        int nr = this.wrappedMap.size();
        V result = this.wrappedMap.remove(key);
        if (nr != this.wrappedMap.size()) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedMap.size()));
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int nr = this.wrappedMap.size();
        this.wrappedMap.putAll(map);
        if (nr != this.wrappedMap.size()) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedMap.size()));
        } else if (!map.isEmpty()) {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedMap.size()));
        }
    }

    @Override
    public void clear() {
        int nr = this.wrappedMap.size();
        this.wrappedMap.clear();
        if (nr != this.wrappedMap.size()) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedMap.size()));
        }
    }

    @Override
    public Set<K> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.wrappedMap.entrySet();
    }
}

