/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event;

import java.io.Serializable;
import org.djutils.event.Event;
import org.djutils.event.EventType;
import org.djutils.exceptions.Throw;

public class TimedEvent<T extends Comparable<T> & Serializable>
extends Event
implements Comparable<TimedEvent<T>> {
    private static final long serialVersionUID = 20140826L;
    private final T timeStamp;

    public TimedEvent(EventType type, Serializable content, T timeStamp) {
        this(type, content, timeStamp, true);
    }

    public TimedEvent(EventType type, Serializable content, T timeStamp, boolean verifyMetaData) {
        super(type, content, verifyMetaData);
        Throw.whenNull(timeStamp, "timeStamp cannot be null");
        this.timeStamp = timeStamp;
    }

    public T getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.timeStamp == null ? 0 : this.timeStamp.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TimedEvent other = (TimedEvent)obj;
        return !(this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp));
    }

    @Override
    public int compareTo(TimedEvent<T> o) {
        return this.timeStamp.compareTo(o.getTimeStamp());
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + ";" + this.getType() + ";" + this.getContent() + ";" + this.getTimeStamp() + "]";
    }
}

