/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.djutils.event.EventListener;
import org.djutils.event.EventType;
import org.djutils.event.reference.Reference;
import org.djutils.event.rmi.RmiEventListener;
import org.djutils.exceptions.Throw;

public final class EventListenerMap
implements Serializable {
    private static final long serialVersionUID = 20140830L;
    private Map<EventType, List<Reference<EventListener>>> map = Collections.synchronizedMap(new LinkedHashMap());

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(EventType eventType) {
        Throw.whenNull(eventType, "Cannot search for a null EventType");
        return this.map.containsKey(eventType);
    }

    public boolean containsValue(EventListener eventListener) {
        Throw.whenNull(eventListener, "Cannot search for a null EventListener");
        for (List<Reference<EventListener>> refList : this.map.values()) {
            for (Reference<EventListener> ref : refList) {
                if (!eventListener.equals(ref.get())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(Reference<EventListener> reference) {
        Throw.whenNull(reference, "Cannot search for a null reference");
        for (List<Reference<EventListener>> refList : this.map.values()) {
            for (Reference<EventListener> ref : refList) {
                if (!reference.equals(ref)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<List<Reference<EventListener>>> values() {
        LinkedHashSet<List<Reference<EventListener>>> result = new LinkedHashSet<List<Reference<EventListener>>>();
        for (List<Reference<EventListener>> list : this.map.values()) {
            result.add(new ArrayList<Reference<EventListener>>(list));
        }
        return result;
    }

    public void putAll(EventListenerMap m) {
        Throw.whenNull(m, "Cannot use putAll for a null map");
        for (Map.Entry<EventType, List<Reference<EventListener>>> entry : m.entrySet()) {
            this.put(entry.getKey(), new ArrayList<Reference<EventListener>>((Collection)entry.getValue()));
        }
    }

    public Set<Map.Entry<EventType, List<Reference<EventListener>>>> entrySet() {
        return this.map.entrySet();
    }

    public Set<EventType> keySet() {
        return new LinkedHashSet<EventType>(this.map.keySet());
    }

    public List<Reference<EventListener>> get(EventType key) {
        Throw.whenNull(key, "Cannot use get for a null EventType key");
        return this.map.get(key);
    }

    public List<Reference<EventListener>> remove(EventType key) {
        Throw.whenNull(key, "Cannot use remove for a null EventType key");
        return this.map.remove(key);
    }

    public List<Reference<EventListener>> put(EventType key, List<Reference<EventListener>> value) {
        Throw.whenNull(key, "Cannot use put with a null EventType key");
        Throw.whenNull(value, "Cannot use put with a null List as value");
        return this.map.put(key, new ArrayList<Reference<EventListener>>(value));
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        LinkedHashMap outMap = new LinkedHashMap();
        for (Map.Entry<EventType, List<Reference<EventListener>>> entry : this.map.entrySet()) {
            outMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        for (Map.Entry<EventType, List<Reference<EventListener>>> entry : this.map.entrySet()) {
            for (Reference<EventListener> reference : entry.getValue()) {
                if (!(reference.get() instanceof RmiEventListener)) continue;
                ((List)outMap.get(entry.getKey())).remove(reference);
            }
            if (!((List)outMap.get(entry.getKey())).isEmpty()) continue;
            outMap.remove(entry.getKey());
        }
        out.writeObject(outMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.map = (LinkedHashMap)in.readObject();
    }
}

