/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event;

import java.io.Serializable;
import java.util.Objects;
import org.djutils.event.EventType;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.MetaData;

public class Event
implements Serializable {
    private static final long serialVersionUID = 20140826L;
    private final EventType type;
    private final Serializable content;

    public Event(EventType type, Serializable content) {
        this(type, content, true);
    }

    public Event(EventType type, Serializable content, boolean verifyMetaData) {
        MetaData metaData;
        Throw.whenNull(type, "type cannot be null");
        this.type = type;
        this.content = content;
        if (verifyMetaData && null != (metaData = type.getMetaData())) {
            if (null != content && !(content instanceof Object[])) {
                metaData.verifyComposition(content);
            } else {
                metaData.verifyComposition((Object[])content);
            }
        }
    }

    public final Serializable getContent() {
        return this.content;
    }

    public EventType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.content, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.content, other.content) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "[" + this.getClass().getName() + ";" + this.getType() + ";" + this.getContent() + "]";
    }
}

