/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.djutils.decoderdumper.CharDecoder;
import org.djutils.decoderdumper.Dumper;
import org.djutils.decoderdumper.FixedString;
import org.djutils.decoderdumper.HexAddressDecoder;
import org.djutils.decoderdumper.HexDecoder;

public class HexDumper
extends Dumper<HexDumper> {
    public HexDumper(int addressOffset) {
        super(addressOffset);
        this.addDecoder(new HexAddressDecoder(16));
        this.addDecoder(new FixedString(": "));
        this.addDecoder(new HexDecoder(16, 8));
        this.addDecoder(new FixedString("  "));
        this.addDecoder(new CharDecoder(16, 8));
        this.addDecoder(new FixedString("\n"));
    }

    public HexDumper() {
        this(0);
    }

    public static String hexDumper(int addressOffset, byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new HexDumper(addressOffset).setOutputStream(baos).append(bytes).flush();
            return baos.toString("UTF-8");
        }
        catch (IOException exception) {
            return "";
        }
    }

    public static String hexDumper(byte[] bytes) {
        return HexDumper.hexDumper(0, bytes);
    }

    @Override
    public String toString() {
        return "HexDumper [super=" + super.toString() + "]";
    }
}

