/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import java.io.IOException;
import org.djutils.decoderdumper.Decoder;

public class HexDecoder
implements Decoder {
    private final String prototypeLine;
    private int fieldsPerLine;
    private final int extraSpaceAfterEvery;
    private StringBuilder buffer = new StringBuilder();

    public HexDecoder(int fieldsPerLine, int extraSpaceAfterEvery) {
        this.fieldsPerLine = fieldsPerLine;
        this.extraSpaceAfterEvery = extraSpaceAfterEvery > 0 ? extraSpaceAfterEvery : Integer.MAX_VALUE;
        String format = String.format("%%%ds", fieldsPerLine * 2 + fieldsPerLine - 1 + (fieldsPerLine - 1) / this.extraSpaceAfterEvery);
        this.prototypeLine = String.format(format, "");
    }

    @Override
    public String getResult() {
        String result = this.buffer.toString();
        this.buffer.setLength(0);
        return result;
    }

    @Override
    public int getMaximumWidth() {
        return this.prototypeLine.length();
    }

    @Override
    public boolean append(int address, byte theByte) throws IOException {
        if (this.buffer.length() == 0) {
            this.buffer.append(this.prototypeLine);
        }
        int lineByte = address % this.fieldsPerLine;
        int index = lineByte * 3 + lineByte / this.extraSpaceAfterEvery;
        this.buffer.replace(index, index + 2, String.format("%02x", theByte));
        return lineByte == this.fieldsPerLine - 1;
    }

    @Override
    public boolean ignoreForIdenticalOutputCheck() {
        return false;
    }

    public String toString() {
        return "HexDecoder [buffer=" + this.buffer + "]";
    }
}

