/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import org.djutils.decoderdumper.Decoder;

public class HexAddressDecoder
implements Decoder {
    private final int roundToMultiple;
    private String result = "";

    public HexAddressDecoder(int roundToMultiple) {
        this.roundToMultiple = roundToMultiple > 0 ? roundToMultiple : 1;
    }

    @Override
    public String getResult() {
        String retVal = this.result;
        this.result = "";
        return retVal;
    }

    @Override
    public int getMaximumWidth() {
        return 8;
    }

    @Override
    public boolean append(int address, byte theByte) {
        this.result = String.format("%08x", address / this.roundToMultiple * this.roundToMultiple);
        return this.roundToMultiple > 1 && address % this.roundToMultiple == this.roundToMultiple - 1;
    }

    @Override
    public boolean ignoreForIdenticalOutputCheck() {
        return true;
    }

    public String toString() {
        return "HexAddressDecoder [result=" + this.result + "]";
    }
}

