/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import java.io.IOException;
import org.djutils.decoderdumper.Decoder;

public class CharDecoder
implements Decoder {
    private final String prototypeLine;
    private final int fieldsPerLine;
    private final int extraSpaceAfterEvery;
    private StringBuilder buffer = new StringBuilder();

    public CharDecoder(int fieldsPerLine, int extraSpaceAfterEvery) {
        this.fieldsPerLine = fieldsPerLine;
        this.extraSpaceAfterEvery = extraSpaceAfterEvery > 0 ? extraSpaceAfterEvery : Integer.MAX_VALUE;
        String format = String.format("%%%ds", fieldsPerLine + (fieldsPerLine - 1) / this.extraSpaceAfterEvery);
        this.prototypeLine = String.format(format, "");
    }

    @Override
    public String getResult() {
        String result = this.buffer.toString();
        this.buffer.setLength(0);
        return result;
    }

    @Override
    public int getMaximumWidth() {
        return this.prototypeLine.length();
    }

    @Override
    public boolean append(int address, byte theByte) throws IOException {
        if (this.buffer.length() == 0) {
            this.buffer.append(this.prototypeLine);
        }
        int lineByte = address % this.fieldsPerLine;
        int index = lineByte + lineByte / this.extraSpaceAfterEvery;
        this.buffer.replace(index, index + 1, (String)(theByte >= 32 && theByte < 127 ? "" + (char)theByte : "."));
        return lineByte == this.fieldsPerLine - 1;
    }

    @Override
    public boolean ignoreForIdenticalOutputCheck() {
        return false;
    }

    public String toString() {
        return "CharDecoder [buffer=" + this.buffer + "]";
    }
}

