/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.djutils.decoderdumper.Base64Decoder;
import org.djutils.decoderdumper.CharDecoder;
import org.djutils.decoderdumper.Dumper;
import org.djutils.decoderdumper.FixedString;
import org.djutils.decoderdumper.HexAddressDecoder;

public class Base64Dumper
extends Dumper<Base64Dumper> {
    public Base64Dumper(int addressOffset) {
        super(addressOffset);
        this.addDecoder(new HexAddressDecoder(16));
        this.addDecoder(new FixedString(" "));
        this.addDecoder(new CharDecoder(16, 4));
        this.addDecoder(new FixedString(": "));
        this.addDecoder(new Base64Decoder(16, 3));
        this.addDecoder(new FixedString("\n"));
    }

    public Base64Dumper() {
        this(0);
    }

    public static String base64Dumper(int addressOffset, byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new Base64Dumper(addressOffset).setOutputStream(baos).append(bytes).flush();
            return baos.toString("UTF-8");
        }
        catch (IOException exception) {
            return "";
        }
    }

    public static String base64Dumper(byte[] bytes) {
        return Base64Dumper.base64Dumper(0, bytes);
    }

    @Override
    public String toString() {
        return "Base64Dumper [super=" + super.toString() + "]";
    }
}

