/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.base;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.djutils.exceptions.Throw;

public class NumberParser {
    private boolean lenient;
    private boolean trailing;
    private Locale locale;
    private int trailingPosition = 0;
    private static Map<Locale, DecimalFormatSymbols> decimalFormatSymbolMap = new LinkedHashMap<Locale, DecimalFormatSymbols>();

    public NumberParser(boolean trailing, boolean lenient, Locale locale) {
        Throw.whenNull(locale, "locale cannot be null");
        this.trailing = trailing;
        this.lenient = lenient;
        this.locale = locale;
    }

    public NumberParser(boolean trailing, boolean lenient) {
        this(trailing, lenient, Locale.getDefault());
    }

    public NumberParser(boolean trailing) {
        this(trailing, true, Locale.getDefault());
    }

    public NumberParser() {
        this(false, true, Locale.getDefault());
    }

    public NumberParser strict() {
        this.lenient = false;
        return this;
    }

    public NumberParser lenient() {
        this.lenient = true;
        return this;
    }

    public NumberParser trailing() {
        this.trailing = true;
        return this;
    }

    public NumberParser noTrailing() {
        this.trailing = false;
        return this;
    }

    public NumberParser locale(Locale newLocale) {
        Throw.whenNull(newLocale, "locale cannot be null");
        this.locale = newLocale;
        return this;
    }

    private Number parse(String text, boolean integerOnly) {
        Throw.whenNull(text, "Cannot parse value from null string");
        Throw.whenNull(this.locale, "Cannot parse value when Locale is null");
        String cleanLeft = text.stripLeading();
        String clean = cleanLeft.stripTrailing();
        if (!decimalFormatSymbolMap.containsKey(this.locale)) {
            decimalFormatSymbolMap.put(this.locale, new DecimalFormatSymbols(this.locale));
        }
        boolean removedPlusAfteExponent = false;
        DecimalFormatSymbols dfs = decimalFormatSymbolMap.get(this.locale);
        if (this.lenient) {
            if (clean.startsWith("+")) {
                clean = clean.substring(1);
                cleanLeft = cleanLeft.substring(1);
            }
            char groupingSeparator = dfs.getGroupingSeparator();
            clean = clean.replaceAll("[" + groupingSeparator + "]", "");
            String exponentSeparator = dfs.getExponentSeparator();
            clean = clean.replace(exponentSeparator.toLowerCase(), exponentSeparator);
            if ((clean = clean.replace(exponentSeparator.toUpperCase(), exponentSeparator)).contains(exponentSeparator + "+")) {
                clean = clean.replace(exponentSeparator + "+", exponentSeparator);
                removedPlusAfteExponent = true;
            }
        }
        Throw.when(clean.isEmpty(), NumberFormatException.class, "Cannot parse a value from an empty string");
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        nf.setParseIntegerOnly(integerOnly);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = nf.parse(clean, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new NumberFormatException("cannot parse");
        }
        if (parsePosition.getIndex() != clean.length()) {
            if (this.trailing) {
                if (this.lenient) {
                    boolean removedPlusAfterExponentInNumber;
                    this.trailingPosition = 0;
                    boolean bl = removedPlusAfterExponentInNumber = removedPlusAfteExponent && clean.substring(0, parsePosition.getIndex() - 1).contains(dfs.getExponentSeparator());
                    for (int index = 0; index < parsePosition.getIndex(); ++index) {
                        if (cleanLeft.charAt(index) == dfs.getGroupingSeparator()) {
                            ++this.trailingPosition;
                        }
                        ++this.trailingPosition;
                    }
                    if (removedPlusAfterExponentInNumber) {
                        ++this.trailingPosition;
                    }
                    this.trailingPosition += text.length() - cleanLeft.length();
                } else {
                    this.trailingPosition = parsePosition.getIndex() + text.length() - cleanLeft.length();
                }
                return number.doubleValue();
            }
            throw new NumberFormatException("trailing characters");
        }
        this.trailingPosition = text.length();
        return number.doubleValue();
    }

    public double parseDouble(String text) {
        return this.parse(text, false).doubleValue();
    }

    public float parseFloat(String text) {
        return this.parse(text, false).floatValue();
    }

    public int parseInt(String text) {
        return this.parse(text, true).intValue();
    }

    public long parseLong(String text) {
        return this.parse(text, true).longValue();
    }

    public int getTrailingPosition() {
        return this.trailingPosition;
    }
}

