/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Iterator;
import org.dizitart.no2.Document;
import org.dizitart.no2.Resettable;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;

abstract class DocumentIterator
implements Iterator<Document> {
    private Resettable<Document> resettable;
    Document nextElement;

    DocumentIterator(Resettable<Document> resettable) {
        this.resettable = resettable;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = true;
        try {
            boolean bl = hasNext = this.nextElement != null;
            return bl;
        }
        finally {
            if (!hasNext) {
                this.resettable.reset();
            }
        }
    }

    @Override
    public Document next() {
        Document returnValue = this.nextElement;
        this.nextMatch();
        return returnValue;
    }

    @Override
    public void remove() {
        throw new InvalidOperationException(ErrorMessage.REMOVE_ON_DOCUMENT_ITERATOR_NOT_SUPPORTED);
    }

    abstract void nextMatch();
}

