/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RecordIterable;
import org.dizitart.no2.Resettable;
import org.dizitart.no2.internals.DocumentIterator;
import org.dizitart.no2.internals.FindResult;
import org.dizitart.no2.internals.ProjectedDocumentIterable;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.Iterables;

class DocumentCursor
implements Cursor {
    private final Set<NitriteId> resultSet;
    private final NitriteMap<NitriteId, Document> underlyingMap;
    private boolean hasMore;
    private int totalCount;
    private Iterator<Document> documentIterator;
    private FindResult findResult;

    DocumentCursor(FindResult findResult) {
        this.resultSet = findResult.getIdSet() != null ? findResult.getIdSet() : new TreeSet<NitriteId>();
        this.underlyingMap = findResult.getUnderlyingMap();
        this.hasMore = findResult.isHasMore();
        this.totalCount = findResult.getTotalCount();
        this.documentIterator = new DocumentCursorIterator(this);
        this.findResult = findResult;
    }

    @Override
    public RecordIterable<Document> project(Document projection) {
        return new ProjectedDocumentIterable(projection, this.findResult);
    }

    @Override
    public Iterator<Document> iterator() {
        return this.documentIterator;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    @Override
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    public Document firstOrDefault() {
        Document item = Iterables.firstOrDefault(this);
        this.reset();
        return item;
    }

    @Override
    public List<Document> toList() {
        List<Document> list = Iterables.toList(this);
        this.reset();
        return list;
    }

    @Override
    public void reset() {
        this.documentIterator = new DocumentCursorIterator(this);
    }

    private class DocumentCursorIterator
    extends DocumentIterator {
        private Iterator<NitriteId> iterator;

        DocumentCursorIterator(Resettable<Document> resettable) {
            super(resettable);
            this.iterator = DocumentCursor.this.resultSet.iterator();
            this.nextMatch();
        }

        @Override
        void nextMatch() {
            while (this.iterator.hasNext()) {
                NitriteId next = this.iterator.next();
                Document document = (Document)DocumentCursor.this.underlyingMap.get(next);
                if (document == null) continue;
                this.nextElement = document;
                return;
            }
            this.nextElement = null;
        }
    }
}

