/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.objects.filters.BaseObjectFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.ValidationUtils;

class InObjectFilter
extends BaseObjectFilter {
    private String field;
    private Object[] values;
    private List<Object> objectList;

    InObjectFilter(String field, Object ... values) {
        this.field = field;
        this.values = values;
        this.objectList = Arrays.asList(values);
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        ValidationUtils.validateInFilterValue(this.field, this.values);
        Object[] valueArray = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.nitriteMapper.isValueType(this.values[i]) || !(this.values[i] instanceof Comparable)) {
                throw new FilterException(ErrorMessage.errorMessage("search term " + this.values[i] + " is not a comparable", 4040));
            }
            valueArray[i] = this.nitriteMapper.isValueType(this.values[i]) ? this.nitriteMapper.asValue(this.values[i]) : this.values[i];
        }
        Filter in = Filters.in(this.field, valueArray);
        in.setNitriteService(this.nitriteService);
        return in.apply(documentMap);
    }

    public String getField() {
        return this.field;
    }

    public Object[] getValues() {
        return this.values;
    }

    public List<Object> getObjectList() {
        return this.objectList;
    }

    public String toString() {
        return "InObjectFilter(field=" + this.getField() + ", values=" + Arrays.deepToString(this.getValues()) + ", objectList=" + this.getObjectList() + ")";
    }
}

